﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.EvaluationSheet
{
    public partial class UCTabEvaluationSheetDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private BL.BO.EvaluationSheet _previousEvaluatonSheet = null;
        private BL.BO.EvaluationSheet _nextEvaluatonSheet = null;

        private int _min = 0;
        private int _max = 100;

        public UCTabEvaluationSheetDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCEvaluationSheetDetails UCDetails
        {
            get { return (UCEvaluationSheetDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            UCDetails.DataManager.Bindings.Add(_gTextBoxName, "Name", _gLabelName);
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviation, "Abbreviation", _gLabelAbbreviation);
            UCDetails.DataManager.Bindings.Add(_gSpinEditSalary, "Salary", _gLabelSalary);

            _gRangeTrackBarFromTo.ValueChanged += new EventHandler(_gRangeTrackBarFromTo_ValueChanged);
        }

        void _gRangeTrackBarFromTo_ValueChanged(object sender, EventArgs e)
        {
            if ((_nextEvaluatonSheet == null) && (_gRangeTrackBarFromTo.Value.Maximum < 100))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarFromTo.Value.Minimum, 100);
            }

            if ((_nextEvaluatonSheet != null) && (_gRangeTrackBarFromTo.Value.Maximum > _max))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarFromTo.Value.Minimum, _max);
            }

            if ((_previousEvaluatonSheet == null) && (_gRangeTrackBarFromTo.Value.Minimum > 0))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(0, _gRangeTrackBarFromTo.Value.Maximum);
            }

            if ((_previousEvaluatonSheet != null) && (_gRangeTrackBarFromTo.Value.Minimum < _min))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_min, _gRangeTrackBarFromTo.Value.Maximum);
            }
        }

        public override void DoRestore()
        {
            if (UCDetails.DataManager.Current != null)
            {
                _previousEvaluatonSheet = UCDetails.BLZSBELearning.EvaluationSheet.RestoreByWeight(UCDetails.DataManager.Current.Weight.Value - 1);
                _nextEvaluatonSheet = UCDetails.BLZSBELearning.EvaluationSheet.RestoreByWeight(UCDetails.DataManager.Current.Weight.Value + 1);

                if (_previousEvaluatonSheet == null)
                {
                    UCDetails.DataManager.Current.From = 0;
                }
                else
                {
                    _min = _previousEvaluatonSheet.From.Value +2;

                    if (UCDetails.DataManager.Current.From < _min)
                    {
                        UCDetails.DataManager.Current.From = _min;
                    }
                }

                if (_nextEvaluatonSheet == null)
                {
                    UCDetails.DataManager.Current.To = 100;
                }
                else
                {
                    _max = _nextEvaluatonSheet.To.Value - 2;

                    if (UCDetails.DataManager.Current.To > _max)
                    {
                        UCDetails.DataManager.Current.To = _max;
                    }
                }

                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(UCDetails.DataManager.Current.From ?? 0, UCDetails.DataManager.Current.To ?? 0);
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                UCDetails.DataManager.Current.From = _gRangeTrackBarFromTo.Value.Minimum;
                UCDetails.DataManager.Current.To = _gRangeTrackBarFromTo.Value.Maximum;

                if (_previousEvaluatonSheet != null)
                {
                    _previousEvaluatonSheet.To = UCDetails.DataManager.Current.From.Value - 1;
                    UCDetails.BLZSBELearning.EvaluationSheet.Save(_previousEvaluatonSheet);
                }

                if (_nextEvaluatonSheet != null)
                {
                    _nextEvaluatonSheet.From = UCDetails.DataManager.Current.To +1;
                    UCDetails.BLZSBELearning.EvaluationSheet.Save(_nextEvaluatonSheet);
                }

            }
            return true;
        }
    }
}
